%% Generate trc file 
function generateTrcFile(time,markerData, markerNames, filename)

% Data=[markerData,coordinateData];
% Labels=[markerNames,coordinateNames];
[datarows, datacols] = size(markerData);
range = [time(1), time(end)];

if length(markerNames) ~= datacols
    error('Number of column names do not match the number of columns\n');
end
nFrames=size(markerData,1);
nMarkers=size(markerData,2); %NB markers or coordinates
Rate=1/mean(diff(time));
trcfile = [filename];
Units='m';
TimeOffset=time(1);
Frames=[1:nFrames]';

% Generate the header for the .trc file
fid = fopen(trcfile, 'wt');
    fprintf(fid, 'PathFileType\t4\t(X/Y/Z)\t%s\n', trcfile);
    fprintf(fid, 'DataRate\tCameraRate\tNumFrames\tNumMarkers\tUnits\tOrigDataRate\tOrigDataStartFrame\tOrigNumFrames\n');
    fprintf(fid, '%f\t%f\t%d\t%d\t%s\t%f\t%d\t%d\n', ...
        Rate, Rate, nFrames, nMarkers, Units, Rate, TimeOffset, nFrames);
    fprintf(fid, 'Frame#\tTime');
    if nMarkers>0;
        for I = 1:nMarkers,
            fprintf(fid,'\t%s\t\t', Labels{I});
        end
        fprintf(fid, '\n\t');
        for I = 1:nMarkers,
            fprintf(fid,'\tX%i\tY%i\tZ%i', I,I,I);
        end
    end

    fprintf(fid, '\n\n');
fclose(fid);

% Now append the data to the file that header has been written out to.
dlmwrite(trcfile, [Frames,time,markerData], '-append', 'delimiter', '\t');

