%% Creates .trc and .mot files 
% Example of how to create OpenSim trc and mot input files
% Uses generateMotfile (by Tim Dorn) and generateTrcFile
% Creation Marjolein van der Krogt, 2012

clear all
close all
format compact

% for .trc:
sf= ...; %sample freq
nsamples= ; %number of samples
time=[0:1/sf:(nsamples-1)/sf]';

Zeros=zeros(length(time),1);
markerData=[]; %marker data in global frame, three columns per marker, X,Y,Z with X anterior, Y upwards, Z to the right
markerNames={'RPSI','LPSI',.. };%marker names, matching with names in OpenSim marker model!
filename='MarkerData.trc';
generateTrcFile(time,markerData,markerNames,filename)

% for .mot:
filename='AnglesAndForces.mot';
coordinateData=[]; % this can be all zeros for the angles, since you're not using angles as input; it can also be left out
Force1=[..]; %GRF data (X Y Z, similar as markers) of force on first foot
COP1=[..]; %point of application, X Y Z
Force2=[..];
COP2=[..];
M1=[..]; % moments on first foot X Y Z, usually only around Y and small
M2=[..];
colnames={'pelvis_tx','pelvis_ty','pelvis_tz','pelvis_list','pelvis_rotation','pelvis_tilt',...
    'hip_flexion_r','hip_adduction_r','hip_rotation_r','knee_angle_r','ankle_angle_r','subtalar_angle_r','mtp_angle_r',...
    'hip_flexion_l','hip_adduction_l','hip_rotation_l','knee_angle_l','ankle_angle_l','subtalar_angle_l','mtp_angle_l',...
    'lumbar_extension','lumbar_bending','lumbar_rotation',...
    'ground_force_vx','ground_force_vy','ground_force_vz','ground_force_px','ground_force_py','ground_force_pz',...
    'ground_force_vx','ground_force_vy','ground_force_vz','ground_force_px','ground_force_py','ground_force_pz',...
    'ground_torque_x','ground_torque_y','ground_torque_z','ground_torque_x','ground_torque_y','ground_torque_z'};
generateMotFile([coordinateData, Force1, COP1, Force2, COP2, M1, M2], colnames, filename)
